***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_monthly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

local latest = tm(2022m8)	

* Vacancy rate
* V/U and 12-month average
g lu	= ln(u)
g lv	= ln(v)
label variable lv "Log vacancy rate"
label variable lu "Log unemployment rate"

* Samples for estimating BC
* COVID era:
g period1 = 1 if t>=tm(2020m4) & t<=`latest'
* Pre-COVID expansion
g period2 = 1 if t>=tm(2009m7) & t<=tm(2020m3)
* GFC and pre-GFC expansion
g period3 = 1 if t>=tm(2001m12) & t<=tm(2009m6)

* COVID
reg lv lu if period1==1, r
predict lvhat
replace lv	= lvhat if lv==.
g vhat		= exp(lvhat)

* Pre-COVID expansion
reg lv lu if period2==1, r
predict lvhatpre
g vhatpre		= exp(lvhatpre)

* GFC and pre-GFC Expansion
reg lv lu if period3==1, r
predict lvhatpregfc
g vhatpregfc		= exp(lvhatpregfc)

***************************************************************
* BC
***************************************************************

local title = "Beveridge Curve"
local title = ""
local index = 0
local label1 = "April 2020 - August 2022"
local label2 = "July 2009 - March 2020"
local label3 = "December 2001 - June 2009"
preserve
keep if t>=tm(2001m4) & t<=`latest'
twoway ///	
(scatter v u if period1==1, msize(small) mcolor(red) mlabsize(small)) ///
(connect v u if period1==1, msize(small) mcolor(red) lcolor(red%50) mlabsize(small)) ///
(line vhat u if period1==1, sort lcolor(red)) ///
(scatter v u if (t==tm(2020m4)|t==tm(2020m12)), mlabposition(9) msize(small) mcolor(black) mfcolor(red) mlabel(t) mlabcolor(black) mlabsize(small)) ///
(scatter v u if t==`latest', mlabposition(2) msize(small) mcolor(black) mfcolor(red) mlabel(t) mlabcolor(black) mlabsize(small)) ///
(scatter v u if period2==1, msize(small) mcolor(blue)) ///
(line vhatpre u if period2==1, sort lcolor(blue)) ///
(scatter v u if period3==1, msize(small) mcolor(midblue) msymbol(X)) ///
(line vhatpregfc u if period3==1, sort lcolor(midblue) lpattern(dash) ///
ytitle("Vacancy rate") ///
title("`title'") ///
legend(label(1 "`label1'") label(6 "`label2'") label(8 "`label3'")) ///
legend(row(3) symxsize(2) ring(0) position(1) bmargin(none) region(style(none))) ///
legend(order(1 6 8)) ///
legend(size(small)) ysize(5) ///
saving(`index'.gph, replace))
rename vhat vline_grey
rename vhatpre vline_blue
rename vhatpregfc vline_lightblue
outsheet v vline_grey vline_blue vline_lightblue u t using "results\charts\Figure 14.xls", replace
restore
